* This program runs TSLS using the DIET file PART 2


*** Author:  Yona Rubinstein
*** Purpose: This program reads data from web


# delimit;
clear ;
clear matrix ;
clear mata ;
set more off ;
set matsize 11000 ;
set maxvar 32767 ;

capture log close ;


global FOLDER "/Users/yonarubinstein/Dropbox/TEACHING/LSE/MG4A4 EMPIRICAL RESEARCH STRATEGY FOR MANAGERIAL ECONOMICS/POST/DATA AND PROGRAMS/" ;

cd "$FOLDER/" ;

log using "$FOLDER/MG4A4 TSLS DIET PART 2.log", replace ;



/* ********************************************************************************************************* */
/* ******************************************* UPLOAD WORKFILE ********************************************* */
/* ********************************************************************************************************* */


use "$DATA/$FILE", clear ;


/*
THE FIRST STEP DESCRIBE YOUR SET OF VARIABLES
*/

des ;

/*
THE 2ND STEP SUMMARIZE THE MAIN STATS
*/

sum ;


/*
1
estimate a first NAIVE MODEL
*/

eststo: reg PWit Diet ;
estimates store OLS, title(OLS) ;

/*
2
estimate a fixed effect model  
*/

eststo: areg PWit Diet, absorb(id) ;
estimates store FE, title(FE) ;


/*
3
estimate 1st Stage
*/

areg Diet Date, absorb(id) ;
estimates store OLS1ST, title(1ST) ;
predict Diethat ;


/*
4
estimate TSLS manually
*/
eststo:  areg PWit Diethat, absorb(id)  ;
estimates store OLS2ND, title(2ND) ;


/*
5
estimate TSLS
*/
eststo:  xtivreg PWit (Diet=Date), fe i(id) ;
estimates store IV, title(ivreg) ;



estout OLS* FE IV using "$FOLDER/MG4A4 TSLS DIET EXAMPLE PART 2.txt", 
replace keep 
(_cons Diet Diethat Date)
cells(b(star fmt(3)) se(par fmt (3)))
varlabels(_cons Constant)
stats(N r2 , fmt(0 3 0) labels(Observations R-square))
starlevels(* 0.10 ** 0.05 *** 0.01)
prehead("TABLE PART 2" "REGRESSION COEFFICIENTS OLS FE 1ST 2ND IV")
posthead("")
prefoot("")
postfoot(""
"Notes."
"TBA"
"Robust standard errors clustered statefip in parentheses."
"* Significant at 10%; ** significant at 5%; *** significant at 1%." ) ;



log close ;



